define("core/notification",["exports","core/pending","core/log"],(function(_exports,_pending,_log){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.saveCancelPromise=_exports.saveCancel=_exports.init=_exports.fetchNotifications=_exports.exception=_exports.deleteCancelPromise=_exports.deleteCancel=_exports.default=_exports.confirm=_exports.alert=_exports.addNotification=void 0,_pending=_interopRequireDefault(_pending),_log=_interopRequireDefault(_log);var _systemImportTransformerGlobalIdentifier="undefined"!=typeof window?window:"undefined"!=typeof self?self:"undefined"!=typeof global?global:{};function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}let currentContextId=M.cfg.contextid;const notificationTypes={success:"core/notification_success",info:"core/notification_info",warning:"core/notification_warning",error:"core/notification_error"},Selectors={notificationRegion:"#".concat("user-notifications"),fallbackRegionParents:["#region-main",'[role="main"]',"body"]},fetchNotifications=async()=>(await("function"==typeof _systemImportTransformerGlobalIdentifier.define&&_systemImportTransformerGlobalIdentifier.define.amd?new Promise((function(resolve,reject){_systemImportTransformerGlobalIdentifier.require(["core/ajax"],resolve,reject)})):"undefined"!=typeof module&&module.exports&&"undefined"!=typeof require||"undefined"!=typeof module&&module.component&&_systemImportTransformerGlobalIdentifier.require&&"component"===_systemImportTransformerGlobalIdentifier.require.loader?Promise.resolve(require("core/ajax")):Promise.resolve(_systemImportTransformerGlobalIdentifier["core/ajax"]))).call([{methodname:"core_fetch_notifications",args:{contextid:currentContextId}}])[0].then(addNotifications);_exports.fetchNotifications=fetchNotifications;const addNotifications=notifications=>{if(!notifications.length)return Promise.resolve();const pendingPromise=new _pending.default("core/notification:addNotifications");return notifications.forEach((notification=>renderNotification(notification.template,notification.variables))),pendingPromise.resolve()},addNotification=notification=>{const pendingPromise=new _pending.default("core/notification:addNotifications");let template=notificationTypes.error;return(notification={closebutton:!0,announce:!0,type:"error",...notification}).template?(template=notification.template,delete notification.template):notification.type&&(void 0!==notificationTypes[notification.type]&&(template=notificationTypes[notification.type]),delete notification.type),renderNotification(template,notification).then(pendingPromise.resolve)};_exports.addNotification=addNotification;const renderNotification=async(template,variables)=>{if(void 0===variables.message||!variables.message)return void _log.default.debug("Notification received without content. Skipping.");const pendingPromise=new _pending.default("core/notification:renderNotification"),Templates=await("function"==typeof _systemImportTransformerGlobalIdentifier.define&&_systemImportTransformerGlobalIdentifier.define.amd?new Promise((function(resolve,reject){_systemImportTransformerGlobalIdentifier.require(["core/templates"],resolve,reject)})):"undefined"!=typeof module&&module.exports&&"undefined"!=typeof require||"undefined"!=typeof module&&module.component&&_systemImportTransformerGlobalIdentifier.require&&"component"===_systemImportTransformerGlobalIdentifier.require.loader?Promise.resolve(require("core/templates")):Promise.resolve(_systemImportTransformerGlobalIdentifier["core/templates"]));Templates.renderForPromise(template,variables).then((_ref=>{let{html:html,js:js=""}=_ref;Templates.prependNodeContents(getNotificationRegion(),html,js)})).then(pendingPromise.resolve).catch(exception)},getNotificationRegion=()=>document.querySelector(Selectors.notificationRegion),alert=async(title,message,cancelText)=>{var pendingPromise=new _pending.default("core/notification:alert");const AlertModal=await("function"==typeof _systemImportTransformerGlobalIdentifier.define&&_systemImportTransformerGlobalIdentifier.define.amd?new Promise((function(resolve,reject){_systemImportTransformerGlobalIdentifier.require(["core/local/modal/alert"],resolve,reject)})):"undefined"!=typeof module&&module.exports&&"undefined"!=typeof require||"undefined"!=typeof module&&module.component&&_systemImportTransformerGlobalIdentifier.require&&"component"===_systemImportTransformerGlobalIdentifier.require.loader?Promise.resolve(require("core/local/modal/alert")):Promise.resolve(_systemImportTransformerGlobalIdentifier["core/local/modal/alert"])),modal=await AlertModal.create({body:message,title:title,buttons:{cancel:cancelText},removeOnClose:!0,show:!0});return pendingPromise.resolve(),modal};_exports.alert=alert;const confirm=(title,question,saveLabel,noLabel,saveCallback,cancelCallback)=>saveCancel(title,question,saveLabel,saveCallback,cancelCallback);_exports.confirm=confirm;const saveCancel=async function(title,question,saveLabel,saveCallback,cancelCallback){let{triggerElement:triggerElement=null}=arguments.length>5&&void 0!==arguments[5]?arguments[5]:{};const pendingPromise=new _pending.default("core/notification:confirm"),[SaveCancelModal,ModalEvents]=await Promise.all(["function"==typeof _systemImportTransformerGlobalIdentifier.define&&_systemImportTransformerGlobalIdentifier.define.amd?new Promise((function(resolve,reject){_systemImportTransformerGlobalIdentifier.require(["core/modal_save_cancel"],resolve,reject)})):"undefined"!=typeof module&&module.exports&&"undefined"!=typeof require||"undefined"!=typeof module&&module.component&&_systemImportTransformerGlobalIdentifier.require&&"component"===_systemImportTransformerGlobalIdentifier.require.loader?Promise.resolve(require("core/modal_save_cancel")):Promise.resolve(_systemImportTransformerGlobalIdentifier["core/modal_save_cancel"]),"function"==typeof _systemImportTransformerGlobalIdentifier.define&&_systemImportTransformerGlobalIdentifier.define.amd?new Promise((function(resolve,reject){_systemImportTransformerGlobalIdentifier.require(["core/modal_events"],resolve,reject)})):"undefined"!=typeof module&&module.exports&&"undefined"!=typeof require||"undefined"!=typeof module&&module.component&&_systemImportTransformerGlobalIdentifier.require&&"component"===_systemImportTransformerGlobalIdentifier.require.loader?Promise.resolve(require("core/modal_events")):Promise.resolve(_systemImportTransformerGlobalIdentifier["core/modal_events"])]),modal=await SaveCancelModal.create({title:title,body:question,buttons:{save:saveLabel},removeOnClose:!0,show:!0});return modal.getRoot().on(ModalEvents.save,saveCallback),modal.getRoot().on(ModalEvents.cancel,cancelCallback),modal.getRoot().on(ModalEvents.hidden,(()=>null==triggerElement?void 0:triggerElement.focus())),pendingPromise.resolve(),modal};_exports.saveCancel=saveCancel;const deleteCancel=async function(title,question,deleteLabel,deleteCallback,cancelCallback){let{triggerElement:triggerElement=null}=arguments.length>5&&void 0!==arguments[5]?arguments[5]:{};const pendingPromise=new _pending.default("core/notification:confirm"),[DeleteCancelModal,ModalEvents]=await Promise.all(["function"==typeof _systemImportTransformerGlobalIdentifier.define&&_systemImportTransformerGlobalIdentifier.define.amd?new Promise((function(resolve,reject){_systemImportTransformerGlobalIdentifier.require(["core/modal_delete_cancel"],resolve,reject)})):"undefined"!=typeof module&&module.exports&&"undefined"!=typeof require||"undefined"!=typeof module&&module.component&&_systemImportTransformerGlobalIdentifier.require&&"component"===_systemImportTransformerGlobalIdentifier.require.loader?Promise.resolve(require("core/modal_delete_cancel")):Promise.resolve(_systemImportTransformerGlobalIdentifier["core/modal_delete_cancel"]),"function"==typeof _systemImportTransformerGlobalIdentifier.define&&_systemImportTransformerGlobalIdentifier.define.amd?new Promise((function(resolve,reject){_systemImportTransformerGlobalIdentifier.require(["core/modal_events"],resolve,reject)})):"undefined"!=typeof module&&module.exports&&"undefined"!=typeof require||"undefined"!=typeof module&&module.component&&_systemImportTransformerGlobalIdentifier.require&&"component"===_systemImportTransformerGlobalIdentifier.require.loader?Promise.resolve(require("core/modal_events")):Promise.resolve(_systemImportTransformerGlobalIdentifier["core/modal_events"])]),modal=await DeleteCancelModal.create({title:title,body:question,buttons:{delete:deleteLabel},removeOnClose:!0,show:!0});return modal.getRoot().on(ModalEvents.delete,deleteCallback),modal.getRoot().on(ModalEvents.cancel,cancelCallback),modal.getRoot().on(ModalEvents.hidden,(()=>null==triggerElement?void 0:triggerElement.focus())),pendingPromise.resolve(),modal};_exports.deleteCancel=deleteCancel;const saveCancelPromise=function(title,question,saveLabel){let{triggerElement:triggerElement=null}=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{};return new Promise(((resolve,reject)=>{saveCancel(title,question,saveLabel,resolve,reject,{triggerElement:triggerElement})}))};_exports.saveCancelPromise=saveCancelPromise;const deleteCancelPromise=function(title,question,deleteLabel){let{triggerElement:triggerElement=null}=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{};return new Promise(((resolve,reject)=>{deleteCancel(title,question,deleteLabel,resolve,reject,{triggerElement:triggerElement})}))};_exports.deleteCancelPromise=deleteCancelPromise;const exception=async ex=>{const pendingPromise=new _pending.default("core/notification:displayException");if(ex.stack||(ex.stack=""),ex.debuginfo&&(ex.stack+=ex.debuginfo+"\n"),!ex.backtrace&&ex.stacktrace&&(ex.backtrace=ex.stacktrace),ex.backtrace){ex.stack+=ex.backtrace;const ln=ex.backtrace.match(/line ([^ ]*) of/),fn=ex.backtrace.match(/ of ([^:]*): /);ln&&ln[1]&&(ex.lineNumber=ln[1]),fn&&fn[1]&&(ex.fileName=fn[1],ex.fileName.length>30&&(ex.fileName="..."+ex.fileName.substr(ex.fileName.length-27)))}void 0===ex.name&&ex.errorcode&&(ex.name=ex.errorcode);(await("function"==typeof _systemImportTransformerGlobalIdentifier.define&&_systemImportTransformerGlobalIdentifier.define.amd?new Promise((function(resolve,reject){_systemImportTransformerGlobalIdentifier.require(["core/yui"],resolve,reject)})):"undefined"!=typeof module&&module.exports&&"undefined"!=typeof require||"undefined"!=typeof module&&module.component&&_systemImportTransformerGlobalIdentifier.require&&"component"===_systemImportTransformerGlobalIdentifier.require.loader?Promise.resolve(require("core/yui")):Promise.resolve(_systemImportTransformerGlobalIdentifier["core/yui"]))).use("moodle-core-notification-exception",(function(){new M.core.exception(ex).show(),pendingPromise.resolve()}))};_exports.exception=exception;const init=(contextId,notificationList)=>{currentContextId=contextId,(()=>{if(getNotificationRegion())return!1;const newRegion=document.createElement("span");newRegion.id="user-notifications",Selectors.fallbackRegionParents.some((selector=>{const targetRegion=document.querySelector(selector);return!!targetRegion&&(targetRegion.prepend(newRegion),!0)}))})(),addNotifications(notificationList)};_exports.init=init;var _default={init:init,fetchNotifications:fetchNotifications,addNotification:addNotification,alert:alert,confirm:confirm,saveCancel:saveCancel,saveCancelPromise:saveCancelPromise,deleteCancelPromise:deleteCancelPromise,exception:exception};return _exports.default=_default,_exports.default}));

//# sourceMappingURL=notification.min.js.map