<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'questionnaire', language 'en'
 *
 * @package    mod_questionnaire
 * @copyright  2018 onward Mike Churchward (mike.churchward@poetopensource.org)
 * @author     Mike Churchward
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['accessibility:rate:choice'] = 'Row {$a->rowposition}, {$a->choicetitle}: Column {$a->colposition}, {$a->choiceanswer}.';
$string['action'] = 'Action';
$string['activityoverview'] = 'You have questionnaires that are due';
$string['additionalinfo'] = 'Additional Info';
$string['additionalinfo_help'] = 'Text to be displayed at the top of the first page of this questionnaire. (i.e. instructions, background info, etc.)';
$string['addnewquestion'] = 'Adding {$a} question';
$string['addnewsection'] = 'Add new section';
$string['addquestion'] = 'Add question...';
$string['addquestions'] = 'Add questions';
$string['addquestiontosection'] = 'Add question to section';
$string['addselqtype'] = 'Add selected question type';
$string['alignment'] = 'Radio buttons Alignment';
$string['alignment_help'] = 'Select buttons alignment: vertical (default) or horizontal.';
$string['alignment_link'] = 'mod/questionnaire/questions#Radio_Buttons';
$string['all'] = 'All';
$string['allnameddegrees'] = 'Named degrees';
$string['allnameddegrees_help'] = 'Specify text to display for rate values instead of the number. Leave a value blank to not use.';
$string['alreadyfilled'] = 'You have already filled out this questionnaire for us{$a}. Thank you.';
$string['andaveragevalues'] = 'and average values';
$string['anonymous'] = 'Anonymous';
$string['answergiven'] = 'This answer given';
$string['answernotgiven'] = 'This answer not given';
$string['answer'] = 'Answer';
$string['answers'] = 'Answers';
$string['answerquestions'] = 'Answer the questions...';
$string['attempted'] = 'This questionnaire has been submitted.';
$string['attemptstillinprogress'] = 'In progress. Saved on:';
$string['autonumbering'] = 'Auto numbering';
$string['autonumbering_help'] = 'Automatic numbering of questions and pages. You might want to disable automatic numbering
 for questionnaires with conditional branching.';
$string['autonumberno'] = 'Do not number questions or pages';
$string['autonumberquestions'] = 'Auto number questions';
$string['autonumberpages'] = 'Auto number pages';
$string['autonumberpagesandquestions'] = 'Auto number pages and questions';
$string['average'] = 'Average';
$string['averageposition'] = 'Average position';
$string['averagerank'] = 'Average rank';
$string['averagesrow'] = 'Averages (where applicable):';
$string['bodytext'] = 'Body text';
$string['boxesnbexact'] = 'exactly {$a} box(es).';
$string['boxesnbmax'] = 'a maximum of {$a} box(es).';
$string['boxesnbmin'] = 'a minimum of {$a} box(es).';
$string['boxesnbreq'] = 'For this question you must tick ';
$string['by'] = ' by ';
$string['missingname'] = 'Question {$a} cannot be used in this feedback section because it does not have a name.';
$string['missingrequired'] = 'Question {$a} cannot be used in this feedback section because it is not required.';
$string['missingnameandrequired'] = 'Question {$a} cannot be used in this feedback section because it does not have a name and it is not required.';
$string['cannotviewpublicresponses'] = 'You cannot view responses to this public questionnaire.';
$string['chart:bipolar'] = 'Bipolar bars';
$string['chart:hbar'] = 'Horizontal bars';
$string['chart:radar'] = 'Radar';
$string['chart:rose'] = 'Rose';
$string['chart:type'] = 'Chart type';
$string['chart:type_help'] = 'Select the Chart type you want to use for this feedback';
$string['chart:vprogress'] = 'Vertical Progress bar';
$string['checkallradiobuttons'] = 'Please check <strong>{$a}</strong> radio buttons!';
$string['checkboxes'] = 'Check Boxes';
$string['checkboxes_help'] = 'Enter one option per line for the user to select one or multiple answers from. ';
$string['checkboxes_link'] = 'mod/questionnaire/questions#Check_Boxes';
$string['checkbreaksadded'] = 'New Page Break(s) inserted at position(s):';
$string['checkbreaksok'] = 'All the required Page breaks are present!';
$string['checkbreaksremoved'] = 'Removed {$a} extra Page break(s).';
$string['checknotstarted'] = 'Select not started';
$string['checkstarted'] = 'Select started';
$string['clicktoswitch'] = '(click to switch)';
$string['closebeforeopen'] = 'You have specified a close date before the open date.';
$string['closed'] = 'The questionnaire was closed on {$a}. Thanks.';
$string['closedate'] = 'Allow responses until';
$string['closeson'] = 'Questionnaire closes on {$a}';
$string['completionsubmit'] = 'Student must submit this questionnaire to complete it';
$string['condition'] = 'Condition';
$string['confalts'] = '- OR - <br />Confirmation page';
$string['configemailreporting'] = 'Allow reports by email';
$string['configemailreportinglong'] = 'Enables options for some reports to be emailed directly to specified email addresses.';
$string['configusergraph'] = 'Display charts for "Personality Test" feedback';
$string['configusergraphlong'] = 'Use the <a href="http://www.rgraph.net/">Rgraph</a> library to display "Personality Test" feedback charts.';
$string['configmaxsections'] = 'Maximum feedback sections';
$string['confirmdelallresp'] = 'Are you sure you want to delete ALL the responses in this questionnaire?';
$string['confirmdelchildren'] = 'If you delete this question, its child(ren) question(s) will also be deleted:';
$string['confirmdelgroupresp'] = 'Are you sure you want to delete ALL the responses of {$a}?';
$string['confirmdelquestion'] = 'Are you sure you want to delete the question at position {$a}?';
$string['confirmdelquestionresps'] = 'This will also delete the {$a} response(s) already given to that question.';
$string['confirmdelresp'] = 'Are you sure you want to delete the response by&nbsp;{$a}&nbsp;?';
$string['confirmdeletesection'] = 'Are you sure you want to delete feedback section "{$a}"?';
$string['confirmremovequestion'] = 'Are you sure you want to remove question "{$a->qname}" from section "{$a->sname}"?';
$string['confpage'] = 'Heading text';
$string['confpage_help'] = 'Heading (in bold) and body text for the "Confirmation" page displayed after a user completes this questionnaire. (URL, if present, takes precedence over confirmation text.) If you leave this field empty, a default message will be displayed upon questionnaire completion (Thank you for completing this Questionnaire).';
$string['confpagedesc'] = 'Heading (in bold) and body text for the &quot;Confirmation&quot; page displayed after a user completes this questionnaire. (URL, if present, takes precedence over confirmation text.)';
$string['contentoptions'] = 'Content options';
$string['couldnotdelresp'] = 'Could not delete response ';
$string['couldnotcreatenewsurvey'] = 'Could not create a new survey!';
$string['createcontent'] = 'Define New Content';
$string['createcontent_help'] = 'Select one of the radio button options. \'Create new\' is the default.';
$string['createcontent_link'] = 'mod/questionnaire/mod#Content_Options';
$string['createnew'] = 'Create new';
$string['centerlabel'] = 'Centre label';
$string['date'] = 'Date';
$string['date_help'] = 'Use this question type if you expect the response to be a correctly formatted date.';
$string['date_link'] = 'mod/questionnaire/questions#Date';
$string['dateformatting'] = 'Use the year-month-day format, e.g. for March 4th, 1945:&nbsp; <strong>1945-03-04</strong>';
// Prior to release 3.6.0, you could specify an input date format in the above string. Now, the format must be as below. This
// string is used now in case sites modified the above string.
$string['strictdateformatting'] = 'Enter the date using the date picker below.';
$string['deleteallresponses'] = 'Delete ALL Responses';
$string['deletecurrentquestion'] = 'Delete question {$a}';
$string['deletedallgroupresp'] = 'Deleted ALL Responses in group {$a}';
$string['deletedallresp'] = 'Questionnaire responses deleted';
$string['deletedisabled'] = 'This item cannot be deleted';
$string['deletedresp'] = 'Deleted Response';
$string['deleteresp'] = 'Delete this Response';
$string['deletesection'] = 'Delete this section';
$string['deletingresp'] = 'Deleting Response';
$string['dependencies'] = 'Dependencies';
$string['dependquestion'] = 'Parent Question';
$string['dependquestion_help'] = 'You can select a parent question and a choice option for this question. A child question will only be displayed
                to the student if its parent question and parent choice have been previously selected.';
$string['dependquestion_link'] = 'mod/questionnaire/questions#Parent_Question';
$string['didnotrespondtoquestion'] = 'Did not respond to question';
$string['directwarnings'] = 'Direct dependencies to this question will be removed. This will affect:';
$string['displaymethod'] = 'Display method not defined for question.';
$string['download'] = 'Download';
$string['downloadpdf'] = 'Download PDF';
$string['downloadtextformat'] = 'Download';
$string['downloadtextformat_help'] = 'This feature enables you to download questionnaire responses in a file format of your choice.
 The file can then be opened in a spreadsheet program (e.g. MS Excel or Open Office Calc) or a statistical package for further processing.';
$string['downloadtextformat_link'] = 'mod/questionnaire/report#Download_in_text_format';
$string['downloadtypes'] = 'Report type';
$string['dropdown'] = 'Dropdown Box';
$string['dropdown_help'] = 'There is no real advantage to using the Dropdown Box over using the Radio Buttons
 except perhaps for longish lists of options, to save screen space.';
$string['dropdown_link'] = 'mod/questionnaire/questions#Dropdown_Box';
$string['edit'] = 'Edit';
$string['editingfeedback'] = 'Editing feedback settings';
$string['editingquestionnaire'] = 'Editing Questionnaire Settings';
$string['editquestion'] = 'Editing {$a} question';
$string['email'] = 'Email';
$string['emailextra'] = 'Send download to emails';
$string['emailextra_help'] = 'Will send the download file to the listed email addresses, separated by commas. Note that NO security or privacy checking is done.
 \'allowemailreporting\' must be enabled in module settings to access this.';
$string['emailsnotspecified'] = 'No email(s) were specified.';
$string['emailroles'] = 'Send download to roles';
$string['emailroles_help'] = 'Will send the download file to all roles with "mod/questionnaire:submissionnotification" capability via email.
 \'allowemailreporting\' must be enabled in module settings to access this.';
$string['emailsend'] = 'Send reports';
$string['emailssent'] = 'Downloads sent to specified email(s).';
$string['errnewname'] = 'Sorry, name already in use. Pick a new name.';
$string['erroropening'] = 'Error opening questionnaire.';
$string['errortable'] = 'Error system table corrupt.';
$string['essaybox'] = 'Essay Box';
$string['essaybox_help'] = 'This question will display a plain text box with x Textarea columns (or area width) and y Textarea rows (number of text lines).

If you leave both x and y to their default 0 value (or if you set it to 0), then moodle\'s HTML editor will be displayed
 with standard height and width (if available in the course/user context & user profile). ';
$string['event_all_responses_deleted'] = 'All Responses deleted';
$string['event_all_responses_saved_as_text'] = 'All Responses saved as text';
$string['event_all_responses_viewed'] = 'All Responses report viewed';
$string['event_individual_responses_viewed'] = 'Individual Responses report viewed';
$string['event_previewed'] = 'Questionnaire previewed';
$string['event_non_respondents_viewed'] = 'Non-respondents viewed';
$string['event_question_created'] = 'Question created';
$string['event_question_deleted'] = 'Question deleted';
$string['event_response_deleted'] = 'Individual Response deleted';
$string['event_resumed'] = 'Attempt resumed';
$string['event_saved'] = 'Responses saved';
$string['event_submitted'] = 'Responses submitted';
$string['feedback'] = 'Feedback';
$string['feedback_help'] = 'Feedback Help';
$string['feedback_link'] = 'mod/questionnaire/personality_test#Editing_Questionnaire_Feedback_Messages';
$string['feedbackaddmorefeedbacks'] = 'Add {no} more feedback fields';
$string['feedbackbysection'] = 'Sections Feedback';
$string['feedbackdefaultlabel'] = '[New section]';
$string['feedbackeditingglobal'] = 'Editing Questionnaire Global Feedback';
$string['feedbackeditingsections'] = 'Editing Questionnaire Feedback Sections';
$string['feedbackeditingmessages'] = 'Editing Questionnaire Feedback Messages';
$string['feedbackeditmessages'] = 'Save Sections settings and edit Feedback Messages';
$string['feedbackeditsections'] = 'Save settings and edit Feedback Sections';
$string['feedbackerrorboundaryformat'] = 'Feedback score boundaries must be either a percentage or a number. The value you entered in boundary {$a} is not recognised.';
$string['feedbackerrorboundaryoutofrange'] = 'Feedback score boundaries must be between 0% and 100%. The value you entered in boundary {$a} is out of range.';
$string['feedbackerrorjunkinboundary'] = 'You must fill in the feedback score boundary boxes without leaving any gaps.';
$string['feedbackerrorjunkinfeedback'] = 'You must fill in the feedback boxes without leaving any gaps.';
$string['feedbackerrororder'] = 'Feedback score boundaries must be in order, highest first. The value you entered in boundary {$a} is out of sequence.';
$string['feedbackglobal'] = 'Global Feedback';
$string['feedbackglobalmessages'] = 'Global Feedback messages';
$string['feedbackglobalheading'] = 'Global Feedback heading';
$string['feedbackheading'] = 'Feedback heading';
$string['feedbackheading_help'] = 'In the feedback heading field you can use 2 variables: $scorepercent and $oppositescorepercent.';
$string['feedbackmessages'] = '{$a} section messages';
$string['feedbacknextsection'] = 'Next section {$a}';
$string['feedbacknone'] = 'No Feedback messages';
$string['feedbacknotes'] = 'Feedback notes';
$string['feedbacknotes_help'] = 'Text entered here will be displayed to the respondents at the end of their Feedback Report';
$string['feedbackoptions'] = 'Feedback options';
$string['feedbackoptions_help'] = 'Feedback options are available if your questionnaire contains the following question types and question settings:
Radio buttons; Dropdown box; Yes/No; Rate (normal or Osgood scale) or Slider. Those questions must be set as Required, their Question Name field must NOT be empty and the Possible answers choices must contain a value.
Slider questions must NOT use a negative value for the Minimum slider range.';
$string['feedbackoptions_link'] = 'mod/questionnaire/personality_test';
$string['feedbackremovequestionfromsection'] = 'This question is part of feedback section [{$a}]';
$string['feedbackremovesection'] = 'Removing this question will completely remove feedback section [{$a}]';
$string['feedbackreport'] = 'Feedback Report';
$string['feedbackscore'] = 'Feedback Score';
$string['feedbackscores'] = 'Display Scores';
$string['feedbackscores_help'] = 'Display the table of feedback scores';
$string['feedbackscoreboundary'] = 'Feedback Score boundary';
$string['feedbacksectionlabel'] = 'Label';
$string['feedbacksectionlabel_help'] = 'This label will be used in the charts/diagrams. Please keep it as short as possible!';
$string['feedbacksectionheading'] = '{$a} section heading';
$string['feedbacksectionheadingmissing'] = 'You must enter a Heading for this Feedback section!';
$string['feedbacksectionheadingtext'] = 'Heading';
$string['feedbackhdr'] = 'Feedbacks';
$string['feedbacksection'] = 'Section';
$string['feedbacksections'] = 'Feedback sections';
$string['feedbacksectionsselect'] = 'Sections';
$string['feedbacksectionsselect_help'] = 'Place your questions into those Sections';
$string['feedbacksectionsselect_link'] = 'mod/questionnaire/personality_test#Editing_Questionnaire_Feedback_Sections_2';
$string['feedbacksettingssaved'] = 'Feedback settings saved';
$string['feedbacksectionquestions'] = '{$a} section questions';
$string['feedbacktype'] = 'Feedback type';
$string['field'] = 'Question {$a}';
$string['fieldlength'] = 'Input box length';
$string['fieldlength_help'] = 'For the **Text Box** question type, enter the **Input Box length** and the **Maximum text length** of text to be entered by
respondent.

Default values are 20 characters for the Input Box width and 25 characters for the maximum length of text entered.';
$string['finished'] = 'You have answered all the questions in this questionnaire!';
$string['firstrespondent'] = 'First Respondent';
$string['formateditor'] = 'HTML editor';
$string['formatplain'] = 'Plain text';
$string['grade'] = 'Submission grade';
$string['gradesdeleted'] = 'Questionnaire grades deleted';
$string['headingtext'] = 'Heading text';
$string['horizontal'] = 'Horizontal';
$string['id'] = 'ID';
$string['includerankaverages'] = 'Include rank question averages';
$string['includechoicecodes'] = 'Include choice codes';
$string['includechoicetext'] = 'Include choice text';
$string['includeincomplete'] = "Include incomplete responses";
$string['incorrectcourseid'] = 'Course ID is incorrect';
$string['incorrectmodule'] = 'Course Module ID was incorrect';
$string['incorrectquestionnaire'] = 'Questionnaire is incorrect';
$string['invalidresponse'] = 'Invalid response specified.';
$string['invalidresponserecord'] = 'Invalid response record specified.';
$string['invalidsurveyid'] = 'Invalid questionnaire ID.';
$string['invalidsectionid'] = 'Invalid feedback section specified.';
$string['invalidrange'] = 'The maximum slider value must be greater than the minimum slider value.';
$string['invalidstartingvalue'] = 'The starting value must be equal to or between the minimum and maximum values. For example, if using a scale of 1-10, the starting value could be 5.';
$string['invalidminmaxrange'] = 'This question type supports an absolute maximum range of -100 to +100. We expect the vast majority of questionnaire designs to use a range of 1-10 or -10 to +10.';
$string['invalidincrement'] = 'Note that the value increments must be lower than the maximum value. For example, if a scale of 1-10, the increment value would probably be 1.';
$string['indirectwarnings'] = 'This list shows the indirect dependent questions and the remaining dependencies for direct dependent questions:';
$string['kindofratescale'] = 'Type of rate scale';
$string['kindofratescale_help'] = 'Right-click on the More Help link below.';
$string['kindofratescale_link'] = 'mod/questionnaire/questions#Type_of_rate_scale';
$string['lastrespondent'] = 'Last Respondent';
$string['length'] = 'Length';
$string['leftlabel'] = 'Left label';
$string['leftpart'] = '{$a->min} is {$a->leftlabel}';
$string['leftpartdefault'] = '{$a->min} is minimum slider range';
$string['managequestions'] = 'Manage questions';
$string['managequestions_help'] = 'In the Manage questions section of the Edit Questions page, you can conduct a number of operations on a Questionnaire\'s questions.';
$string['managequestions_link'] = 'mod/questionnaire/questions#Manage_questions';
$string['mandatory'] = 'Mandatory - All these dependencies must be fulfilled.';
$string['maxdigitsallowed'] = 'Max. digits allowed';
$string['maxdigitsallowed_help'] = 'Use **Max. digits allowed** to set a limit to the number of characters entered for a Numeric question. Note that the
decimal point also counts as one character!';
$string['maxdigitsallowed_link'] = 'mod/questionnaire/questions#Numeric';
$string['maxforcedresponses'] = 'Max. forced responses';
$string['maxforcedresponses_help'] = 'Use these parameters to force respondent to tick a minimum of **Min.** boxes and a maximum of **Max.** check boxes. To
force an exact number of check boxes to be ticked, set **Min.** and **Max.** to the same value. If only a min or a max value is desired, just leave the other
value to its default **0** value. If you set **Min.** or **Max.** to values other than their default **0** value, a warning message will be displayed if
respondent does not comply with your requirements. Obviously you should make any requirements clear to the respondent either in the general instructions of
your Questionnaire or in the text of relevant questions.';
$string['maxtextlength'] = 'Max. text length';
$string['maxtextlength_help'] = 'For the Text Box question type, enter the Input Box length and the Maximum text length of text to be entered by respondent.
Default values are 20 characters for the Input Box width and 25 characters for the maximum length of text entered.';
$string['messageprovider:message'] = 'Questionnaire reminder';
$string['messageprovider:notification'] = 'Questionnaire submission';
$string['middlepart'] = ', {$a->centreval} is {$a->middlelabel}';
$string['middlepartdefault'] = ', {$a->centreval} is average';
$string['middlepartwithtwovalues'] = ', {$a->centreval1} and {$a->centreval2} are {$a->middlelabel}';
$string['middlepartwithtwovaluesdefault'] = ', {$a->centreval1} and {$a->centreval2} are average';
$string['minforcedresponses'] = 'Min. forced responses';
$string['minforcedresponses_help'] = 'Use these parameters to force respondent to tick a minimum of **Min.** boxes and a maximum of **Max.** check boxes. To
force an exact number of check boxes to be ticked, set **Min.** and **Max.** to the same value. If only a min or a max value is desired, just leave the other
value to its default **0** value. If you set **Min.** or **Max.** to values other than their default **0** value, a warning message will be displayed if
respondent does not comply with your requirements. Obviously you should make any requirements clear to the respondent either in the general instructions of
your Questionnaire or in the text of relevant questions.';
$string['misconfigured'] = 'Course is misconfigured';
$string['missingquestion'] = 'Please answer required question ';
$string['missingquestions'] = 'Please answer required questions: ';
$string['modulename'] = 'Questionnaire';
$string['modulename_help'] = 'The questionnaire module allows you to construct surveys using a variety of question types, for the purpose of gathering data from users.';
$string['modulename_link'] = 'mod/questionnaire/view';
$string['modulenameplural'] = 'Questionnaires';
$string['movedisabled'] = 'This item cannot be moved';
$string['myresponses'] = 'All your responses';
$string['myresponsetitle'] = 'Your {$a} response(s)';
$string['myresults'] = 'Your Results';
$string['minrange'] = 'Minimum slider range (left)';
$string['minrange_help'] = 'Set the minimum value of the range on the left-hand side. It defaults to 1, but can set as low as -100. If you use a negative number (-100 to -1), the right-hand maximum will be expressed with a positive (+) sign.';
$string['maxrange'] = 'Maximum slider range (right)';
$string['maxrange_help'] = 'Set the maximum value of the range on the right-hand side. It defaults to 100, but it could be  any number between 1-100. If the minimum value for the left-hand is a negative value, the maximum range will be expressed with a positive (+) sign.';
$string['name'] = 'Name';
$string['navigate'] = 'Allow branching questions';
$string['navigate_help'] = 'Enable Yes/No and Radio Buttons questions to have Child questions dependent on their choices in your questionnaire.';
$string['navigate_link'] = 'mod/questionnaire/conditional_branching';
$string['navigatetosection'] = 'Go to feedback section';
$string['next'] = 'Next';
$string['nextpage'] = 'Next Page';
$string['nlines'] = '{$a} lines';
$string['noanswer'] = 'No answer';
$string['noattempts'] = 'No attempts have been made on this questionnaire';
$string['nodata'] = 'No data posted.';
$string['noduplicates'] = 'No duplicate choices';
$string['noduplicateschoiceserror'] = 'You must enter at least 2 Possible answers for the "No duplicate choices" option!';
$string['notenoughscaleitems'] = 'You must enter a minimum value of 2 scale items!';
$string['noneinuse'] = 'This questionnaire does not contain any questions.';
$string['non_respondents'] = 'Users who have not yet submitted their responses to this questionnaire';
$string['nopublicsurveys'] = 'No public questionnaires.';
$string['noresponsedata'] = 'No responses for this question.';
$string['noresponses'] = 'No responses';
$string['normal'] = 'Normal';
$string['notanumber'] = '<strong>{$a}</strong> is not an accepted number format.';
$string['notapplicable'] = 'N/A';
$string['notapplicablecolumn'] = 'N/A column';
$string['notavail'] = 'This questionnaire is no longer available. Ask your teacher to delete it.';
$string['noteligible'] = 'You are not eligible to take this questionnaire.';
$string['notemplatesurveys'] = 'No template questionnaires.';
$string['notificationfull'] = 'Full submission';
$string['notifications'] = 'Send submission notifications';
$string['notificationsimple'] = 'Notification only';
$string['notifications_help'] = 'Notify roles with the "mod/questionnaire:submissionnotification" capability when a submission is made.';
$string['notifications_link'] = 'mod/questionnaire/mod#Submission_Notifications';
$string['notopen'] = 'This questionnaire will not open until {$a}.';
$string['notrequired'] = 'Response is not required';
$string['notset'] = 'not set';
$string['not_started'] = 'not started';
$string['nousersselected'] = 'No users selected';
$string['num'] = '#';
$string['numattemptsmade'] = '{$a} attempts made on this questionnaire';
$string['numberfloat'] = 'The number you entered <strong>{$a->number}</strong> has been reformatted/rounded with <strong>{$a->precision}</strong> decimal place(s).';
$string['numberofdecimaldigits'] = 'Nb of decimal digits';
$string['numberofdecimaldigits_help'] = 'Use **Nb of decimal digits** to specify the format of the Average value counted and displayed at the Questionnaire Report page.';
$string['numberofdecimaldigits_link'] = 'mod/questionnaire/questions#Numeric';
$string['numberscaleitems'] = 'Nb of scale items';
$string['numberscaleitems_help'] = 'Nb of scale items is the *number of items* to be used in your rate scale. You would normally use a value of 3 to 5. Default value: **5**.';
$string['numeric'] = 'Numeric';
$string['numeric_help'] = 'Use this question type if you expect the response to be a correctly formatted number.';
$string['of'] = 'of';
$string['openafterclose'] = 'You have specified an open date after the close date';
$string['opendate'] = 'Allow responses from';
$string['option'] = 'option {$a}';
$string['optional'] = 'Optional - At least one of this dependencies has to be fulfilled.';
$string['optionalname'] = 'Question Name';
$string['optionalname_help'] = 'The Question Name is only used when you export responses to CSV/Excel format.
 If you never export to CSV, then you needn\'t worry about Question names at all.
 If you plan to regularly export your questionnaire data to CSV, then you have a choice of two options for question naming. ';
$string['optionalname_link'] = 'mod/questionnaire/questions#Question_Name';
$string['or'] = '- OR -';
$string['order_ascending'] = 'Ascending order';
$string['order_default'] = 'View Default order';
$string['order_descending'] = 'Descending order';
$string['orderresponses'] = 'Order Responses';
$string['orderresponses_help'] = 'When displaying All Responses you can order the choices by number of responses (the Average column) for the following
 4 types of questions.

* single choices radio button
* single choices dropdown list
* multiple choices (check boxes)
* rate questions (including Likert scales).

When you arrive on the All Responses page, by default all responses are ordered in the order that the questionnaire creator entered the question choices.
 You can choose to order them by ascending or descending order.';
$string['orderresponses_link'] = 'mod/questionnaire/report#Order_Responses';
$string['osgood'] = 'Osgood';
$string['other'] = 'Other:';
$string['otherempty'] = 'If you tick this choice you must enter some text in the text box!';
$string['overviewnumresplog'] = 'responses';
$string['overviewnumresplog1'] = 'response';
$string['overviewnumrespvw'] = 'responses';
$string['overviewnumrespvw1'] = 'response';
$string['owner'] = 'Owner';
$string['page'] = 'Page';
$string['pageof'] = 'Page {$a->page} of {$a->totpages}';
$string['parent'] = 'Parent';
$string['participant'] = 'Participant';
$string['pleasecomplete'] = 'Please complete this choice.';
$string['pluginadministration'] = 'Questionnaire administration';
$string['pluginname'] = 'Questionnaire';
$string['position'] = 'position';
$string['possibleanswers'] = 'Possible answers';
$string['posteddata'] = 'Reached page with posted data:';
$string['preview_label'] = 'Preview';
$string['preview_questionnaire'] = 'Questionnaire Preview';
$string['previewing'] = ' Previewing Questionnaire ';
$string['previous'] = 'Previous';
$string['previouspage'] = 'Previous Page';
$string['print'] = 'Print this Response';
$string['printblank'] = 'Print Blank';
$string['printblanktooltip'] = 'Opens printer-friendly window with blank Questionnaire';
$string['printtooltip'] = 'Opens printer-friendly window with current Response';

$string['privacy:metadata:questionnaire_response'] = 'A response in progress or submitted';
$string['privacy:metadata:questionnaire_response:userid'] = 'The ID of the user for this response.';
$string['privacy:metadata:questionnaire_response:questionnaireid'] = 'The ID of the questionnaire record for this response.';
$string['privacy:metadata:questionnaire_response:complete'] = 'The response completion status.';
$string['privacy:metadata:questionnaire_response:grade'] = 'The grade for this response.';
$string['privacy:metadata:questionnaire_response:submitted'] = 'The timestamp for the most recent save for this response.';

$string['privacy:metadata:questionnaire_response_bool'] = 'A boolean (yes/no) question response.';
$string['privacy:metadata:questionnaire_response_bool:response_id'] = 'The ID of the response record for this response.';
$string['privacy:metadata:questionnaire_response_bool:question_id'] = 'The ID of the question record for this response.';
$string['privacy:metadata:questionnaire_response_bool:choice_id'] = 'The specific boolean answer.';

$string['privacy:metadata:questionnaire_response_date'] = 'A date question response.';
$string['privacy:metadata:questionnaire_response_date:response_id'] = 'The ID of the response record for this response.';
$string['privacy:metadata:questionnaire_response_date:question_id'] = 'The ID of the question record for this response.';
$string['privacy:metadata:questionnaire_response_date:response'] = 'The specific date answer.';

$string['privacy:metadata:questionnaire_response_other'] = 'An \'other\' choice text response.';
$string['privacy:metadata:questionnaire_response_other:response_id'] = 'The ID of the response record for this response.';
$string['privacy:metadata:questionnaire_response_other:question_id'] = 'The ID of the question record for this response.';
$string['privacy:metadata:questionnaire_response_other:choice_id'] = 'The ID of the choice record for this response.';
$string['privacy:metadata:questionnaire_response_other:response'] = 'The specific text answer.';

$string['privacy:metadata:questionnaire_response_rank'] = 'A rank question response.';
$string['privacy:metadata:questionnaire_response_rank:response_id'] = 'The ID of the response record for this response.';
$string['privacy:metadata:questionnaire_response_rank:question_id'] = 'The ID of the question record for this response.';
$string['privacy:metadata:questionnaire_response_rank:choice_id'] = 'The ID of the choice record for this response.';
$string['privacy:metadata:questionnaire_response_rank:rankvalue'] = 'The specific rank answer.';

$string['privacy:metadata:questionnaire_response_text'] = 'A text question response.';
$string['privacy:metadata:questionnaire_response_text:response_id'] = 'The ID of the response record for this response.';
$string['privacy:metadata:questionnaire_response_text:question_id'] = 'The ID of the question record for this response.';
$string['privacy:metadata:questionnaire_response_text:response'] = 'The specific text answer.';

$string['privacy:metadata:questionnaire_resp_multiple'] = 'A multiple choice question response.';
$string['privacy:metadata:questionnaire_resp_multiple:response_id'] = 'The ID of the response record for this response.';
$string['privacy:metadata:questionnaire_resp_multiple:question_id'] = 'The ID of the question record for this response.';
$string['privacy:metadata:questionnaire_resp_multiple:choice_id'] = 'The ID of a choice record for this response.';

$string['privacy:metadata:questionnaire_resp_single'] = 'A single choice question response.';
$string['privacy:metadata:questionnaire_resp_single:response_id'] = 'The ID of the response record for this response.';
$string['privacy:metadata:questionnaire_resp_single:question_id'] = 'The ID of the question record for this response.';
$string['privacy:metadata:questionnaire_resp_single:choice_id'] = 'The ID of the choice record for this response.';

$string['private'] = 'Private';
$string['progressbar'] = 'Show progress bar';
$string['progresshelp'] = 'Progress Bar';
$string['progresshelp_help'] = 'Move on to the next page to fill up the progress bar';
$string['progressbar_info'] = 'Questionnaire {$a} complete.';
$string['public'] = 'Public';
$string['publiccopy'] = 'Copy:';
$string['publicoriginal'] = 'Original:';
$string['qtype'] = 'Type';
$string['qtype_help'] = 'Select whether users will be allowed to respond once, daily, weekly, monthly or an unlimited number of times (many).';
$string['qtypedaily'] = 'respond daily';
$string['qtypemonthly'] = 'respond monthly';
$string['qtypeonce'] = 'respond once';
$string['qtypeunlimited'] = 'respond many';
$string['qtypeweekly'] = 'respond weekly';
$string['questionnaire:addinstance'] = 'Add a new questionnaire';
$string['questionnaire:copysurveys'] = 'Copy template and private questionnaires';
$string['questionnaire:createpublic'] = 'Create public questionnaires';
$string['questionnaire:createtemplates'] = 'Create template questionnaires';
$string['questionnaire:deleteresponses'] = 'Delete any response';
$string['questionnaire:downloadresponses'] = 'Download responses in a CSV file';
$string['questionnaire:editquestions'] = 'Create and edit questionnaire questions';
$string['questionnaire:manage'] = 'Create and edit questionnaires';
$string['questionnaire:message'] = 'Send message to non-respondents';
$string['questionnaire:preview'] = 'Preview questionnaires';
$string['questionnaire:printblank'] = 'Print blank questionnaire';
$string['questionnaire:readallresponseanytime'] = 'Read all responses any time';
$string['questionnaire:readallresponses'] = 'Read response summaries, subject to open times';
$string['questionnaire:readownresponses'] = 'Read own responses';
$string['questionnaire:submissionnotification'] = 'Receive notification for each submission';
$string['questionnaire:submit'] = 'Complete and submit a questionnaire';
$string['questionnaire:view'] = 'View a questionnaire';
$string['questionnaire:viewsingleresponse'] = 'View complete individual responses';
$string['questionnaireadministration'] = 'Questionnaire Administration';
$string['questionnairecloses'] = 'Questionnaire Closes';
$string['questionnaireopens'] = 'Questionnaire Opens';
$string['questionnairereport'] = 'Questionnaire Report';
$string['questionnum'] = 'Question #';
$string['questions'] = 'Questions';
$string['questionsinsection'] = 'Questions in this section:';
$string['questiontypes'] = 'Question types';
$string['questiontypes_help'] = 'See the Moodle Documentation below';
$string['questiontypes_link'] = 'mod/questionnaire/questions#Question_Types';
$string['radiobuttons'] = 'Radio Buttons';
$string['radiobuttons_help'] = 'In this question type, the respondent must select one out of the choices offered.';
$string['radiobuttons_link'] = 'mod/questionnaire/questions#Radio_Buttons';
$string['rank'] = 'Rank';
$string['ratescale'] = 'Rate (scale 1..5)';
$string['ratescale_help'] = 'See the Moodle Documentation below';
$string['ratescale_link'] = 'mod/questionnaire/questions#Rate_.28scale_1..5.29';
$string['realm'] = 'Questionnaire Type';
$string['realm_help'] = '* **There are  three types of questionnaires:**
 * Private - belongs to the course it is defined in only.
 * Template - can be copied and edited.
 * Public - can be shared among courses.';
$string['realm_link'] = 'mod/questionnaire/qsettings#Questionnaire_Type';
$string['redirecturl'] = 'The URL to which a user is redirected after completing this questionnaire.';
$string['remove'] = 'Delete';
$string['removenotinuse'] = 'This questionnaire used to depend on a Public questionnaire which has been deleted.
It can no longer be used and should be deleted.';
$string['required'] = 'Response is required';
$string['required_help'] = 'If you select ***Yes***, response to this question will be required, i.e.
the respondent will not be able to submit the questionnaire
until this question has been answered.';
$string['required_link'] = 'mod/questionnaire/questions#Response_Required';
$string['requiredparameter'] = 'A required parameter was missing.';
$string['reset'] = 'Reset';
$string['removeallquestionnaireattempts'] = 'Delete all questionnaire responses';
$string['respeligiblerepl'] = '(replaced by role overrides)';
$string['respondent'] = 'Respondent';
$string['respondenteligibleall'] = 'all';
$string['respondenteligiblestudents'] = 'students only';
$string['respondenteligibleteachers'] = 'teachers only';
$string['respondents'] = 'Respondents';
$string['respondenttype'] = 'Respondent Type';
$string['respondenttype_help'] = 'You can display your users\' full names with each response by setting this to "fullname".
You can hide your users\' identities from the responses by setting this to "anonymous".';
$string['respondenttype_link'] = 'mod/questionnaire/mod#Respondent_Type';
$string['respondenttypeanonymous'] = 'anonymous';
$string['respondenttypefullname'] = 'fullname';
$string['response'] = 'Response';
$string['responsefieldlines'] = 'Input box size';
$string['responseformat'] = 'Response format';
$string['responseoptions'] = 'Response options';
$string['responses'] = 'Responses';
$string['responseview'] = 'Students can view ALL responses';
$string['responseview_help'] = 'You can specify who can see the responses of all respondents to submitted questionnaires (general statistics tables).';
$string['responseview_link'] = 'mod/questionnaire/mod#Response_viewing';
$string['responseviewstudentsalways'] = 'Always';
$string['responseviewstudentsnever'] = 'Never';
$string['responseviewstudentswhenanswered'] = 'After answering the questionnaire';
$string['responseviewstudentswhenclosed'] = 'After the questionnaire is closed';
$string['restrictedtoteacher'] = 'These functions are restricted to editing teachers only!';
$string['resume'] = 'Save/Resume answers';
$string['resume_help'] = 'Setting this option allows users to save their answers to a questionnaire before submitting them.
 Users can leave the questionnaire unfinished and resume from the save point at a later date.';
$string['resume_link'] = 'mod/questionnaire/mod#Save/Resume_answers';
$string['resumesurvey'] = 'Resume questionnaire';
$string['return'] = 'Return';
$string['rightlabel'] = 'Right label';
$string['rightpart'] = ' and {$a->max} is {$a->rightlabel}';
$string['rightpartdefault'] = ' and {$a->max} is maximum slider range';
$string['save'] = 'Save';
$string['save_and_exit'] = 'Save and exit';
$string['saveasnew'] = 'Save as New Question';
$string['savedbutnotsubmitted'] = 'This questionnaire has been saved but not yet submitted.';
$string['savedprogress'] = 'Your progress has been saved.  You may return at any time to complete this questionnaire.';
$string['saveeditedquestion'] = 'Save question {$a}';
$string['savesettings'] = 'Save settings';
$string['search:activity'] = 'Questionnaire - activity information';
$string['search:question'] = 'Questionnaire - questions';
$string['section'] = 'Description';
$string['sectionbreak'] = '----- Page Break -----';
$string['sectionbreak_help'] = '----- Page Break -----';
$string['sectionsnotset'] = 'You must select at least ONE question per section!<br />Section(s) not selected: {$a}';
$string['sectiontext'] = 'Label';
$string['sectiontext_help'] = 'This is not a question but a (short) text which will be displayed to introduce a series of questions.';
$string['selecttheme'] = 'Select a theme (css) to use with this questionnaire.';
$string['send'] = 'Send';
$string['sendemail'] = 'Send email';
$string['send_message'] = 'Send message to selected users';
$string['send_message_to'] = 'Send message to:';
$string['sendemail_help'] = 'Sends a copy of each submission to the specified address or addresses.
You can provide more than one address by separating them with commas.
Leave blank for no email backup. \'allowemailreporting\' must be enabled in module settings to access this.';
$string['set'] = 'set';
$string['settings'] = 'Settings';
$string['settingssaved'] = 'Settings saved';
$string['show_nonrespondents'] = 'Non-respondents';
$string['started'] = 'started';
$string['strfdate'] = '%d/%m/%Y';
$string['strfdateformatcsv'] = 'd/m/Y H:i:s';
$string['submissionnotificationhtmlanon'] = 'There is a new <a href="{$a->submissionurl}">submission</a> to the "{$a->name}" questionnaire.';
$string['submissionnotificationhtmluser'] = '<a href="{$a->profileurl}">{$a->username}</a> has a new <a href="{$a->submissionurl}">submission</a> to the "{$a->name}" questionnaire in the course "{$a->coursename}".';
$string['submissionnotificationsubject'] = 'New questionnaire submission';
$string['submissionnotificationtextanon'] = 'There is a new submission ({$a->submissionurl}) to the "{$a->name}" questionnaire.';
$string['submissionnotificationtextuser'] = '{$a->username} ({$a->profileurl}) has a new submission ({$a->submissionurl}) to the "{$a->name}" questionnaire in the course "{$a->coursename}".';
$string['submitoptions'] = 'Submission options';
$string['submitpreview'] = 'Submit preview';
$string['submitpreviewcorrect'] = 'This submission would be accepted as correctly filled in.';
$string['submitsurvey'] = 'Submit questionnaire';
$string['submitted'] = 'Submitted on:';
$string['subtitle'] = 'Subtitle';
$string['subtitle_help'] = 'Subtitle of this questionnaire. Appears below the title on the first page only.';
$string['subject'] = 'Subject';
$string['summary'] = 'Summary';
$string['summaryreportattached'] = 'Questionnaire summary report attached';
$string['surveynotexists'] = 'questionnaire does not exist.';
$string['surveyowner'] = 'You must be a questionnaire owner to perform this operation.';
$string['surveyresponse'] = 'Response from questionnaire';
$string['slider'] = 'Slider';
$string['slider_help'] = 'The slider question allows respondents to select a value from a continuous range by dragging a slider between two extremes. A centre value can also be set.';
$string['startingvalue'] = 'Slider starting value';
$string['startingvalue_help'] = 'The slider starting value specifies where the slider should first appear for respondents. It defaults to 1 because the range is unknown. You may wish to start it in the centre of the range by giving a central value (a range of 1-100 has a centre value of 50).';
$string['stepvalue'] = 'Slider increment value';
$string['stepvalue_help'] = 'The slider increment value specifies how finely you wish respondents to indicate their response in the range. The question defaults to a range of 1-100 with an increment of one, allowing respondents to give values of 70, 71, 72, 73, 74 etc. But you could instead set increments of five, allowing respondents to give values of 60, 65, 70, 75, 80 etc., or even just a range of 1-10 with increments of 1.';
$string['template'] = 'Template';
$string['templatenotviewable'] = 'Template questionnaires are not viewable.';
$string['text'] = 'Question Text';
$string['textareacolumns'] = 'Textarea columns';
$string['textareacolumns_help'] = 'This question will display a plain text box with **x** *Textarea columns* (or area *width*) and **y** *Textarea rows* (number of text
*lines*).
If you leave both x and y to their default **0** value (or if you set it to **0**), then HTML editor will be displayed with standard height and width (if
available in the course/user context &amp; user profile).';
$string['textarearows'] = 'Textarea rows';
$string['textbox'] = 'Text Box';
$string['textbox_help'] = 'For the Text Box question type, enter the Input Box length and the Maximum text length of text to be entered by respondent.
Default values are 20 characters for the Input Box width and 25 characters for the maximum length of text entered.';
$string['textdownloadoptions'] = 'Options for CSV download';
$string['thank_head'] = 'Thank you for completing this Questionnaire.';
$string['theme'] = 'Theme';
$string['thismonth'] = 'this month';
$string['thisresponse'] = 'This response';
$string['thisweek'] = 'this week';
$string['thousands'] = 'Do not use thousands separators.';
$string['title'] = 'Title';
$string['title_help'] = 'Title of this questionnaire, which will appear at the top of every page. By default Title is set to the questionnaire Name, but you can edit it as you like.';
$string['today'] = 'today';
$string['total'] = 'Total';
$string['totalofnumbers'] = 'Total of numbers entered';
$string['totalresponses'] = 'Total responses to question';
$string['type'] = 'Question Type';
$string['undefinedquestiontype'] = 'Undefined question type!';
$string['unknown'] = 'Unknown';
$string['unknownaction'] = 'Unknown questionnaire action specified...';
$string['url'] = 'Confirmation URL';
$string['url_help'] = 'The URL to which a user is redirected after completing this questionnaire.';
$string['useprivate'] = 'Copy existing';
$string['usepublic'] = 'Use public';
$string['usetemplate'] = 'Use template';
$string['vertical'] = 'Vertical';
$string['view'] = 'View';
$string['viewallresponses'] = 'View all responses';
$string['viewallresponses_help'] = 'If the questionnaire is set to **Group Mode**: *Visible groups*, or is set to *Separate groups* and the current user
 has the *moodle/site:accessallgroups* capability (in the current context), and groups have been defined in the current course,
 then the user has access to a dropdown list of groups. This dropdown list enables the user to "filter" the questionnaire responses by groups.
 If the setting is **Group Mode**: *Separate groups*, then users who do not have the *moodle/site:accessallgroups* capability
 (usually students, or non-editing teachers, etc.) will only be able to view the responses of the group(s) they belong to.';
$string['viewallresponses_link'] = 'Viewing_Questionnaire_responses#Group_filtering';
$string['viewbyresponse'] = 'List of responses';
$string['viewindividualresponse'] = 'Individual responses';
$string['viewindividualresponse_help'] = 'Click on the respondents\' names in the list below to view their individual responses.';
$string['viewresponses'] = 'All responses ({$a})';
$string['viewyourresponses'] = 'View your response(s)';
$string['warning'] = 'Warning, error encountered.';
$string['where'] = 'where ';
$string['wronganswers'] = 'There is something wrong with your answers (see below)';
$string['wrongdateformat'] = 'The date entered: <strong>{$a}</strong> does not correspond to the format shown in the example.';
$string['wrongdaterange'] = 'ERROR! The year must be set in the 1902 to 2037 range.';
$string['wrongformat'] = 'There is something wrong with your answer to question:&nbsp;';
$string['wrongformats'] = 'There is something wrong with your answer to questions:&nbsp;';
$string['yesno'] = 'Yes/No';
$string['yesno_help'] = 'Simple Yes/No question.';
$string['yourresponse'] = 'View your response(s)';
$string['yourresponses'] = 'View your response(s)';
$string['crontask'] = 'Questionnaire cleanup job';
$string['nopermissions'] = 'Sorry, but you do not currently have permissions to view this page or perform this action.';
$string['unanswered'] = 'Unanswered';
