/**
 * Controls the contacts page of the message drawer.
 *
 * @module     core_message/message_drawer_view_contacts
 * @copyright  2018 Ryan Wyllie <ryan@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("core_message/message_drawer_view_contacts",["jquery","core/pubsub","core/str","core_message/message_drawer_events","core_message/message_drawer_view_contacts_section_contacts","core_message/message_drawer_view_contacts_section_requests"],(function($,PubSub,Str,MessageDrawerEvents,ContactsSection,RequestsSection){var SELECTORS_ACTION_SHOW_CONTACTS_SECTION='[data-action="show-contacts-section"]',SELECTORS_ACTION_SHOW_REQUESTS_SECTION='[data-action="show-requests-section"]',SELECTORS_CONTACT_REQUEST_COUNT='[data-region="contact-request-count"]',SELECTORS_CONTACTS_SECTION_CONTAINER='[data-section="contacts"]',SELECTORS_REQUESTS_SECTION_CONTAINER='[data-section="requests"]',getContactsSectionContainer=function(body){return body.find(SELECTORS_CONTACTS_SECTION_CONTAINER)},getRequestsSectionContainer=function(body){return body.find(SELECTORS_REQUESTS_SECTION_CONTAINER)},getShowContactsAction=function(body){return body.find(SELECTORS_ACTION_SHOW_CONTACTS_SECTION)},getShowRequestsAction=function(body){return body.find(SELECTORS_ACTION_SHOW_REQUESTS_SECTION)},decrementContactRequestCount=function(body){return function(){var countContainer=body.find(SELECTORS_CONTACT_REQUEST_COUNT),count=parseInt(countContainer.text(),10);(count=isNaN(count)?0:count-1)<=0?countContainer.addClass("hidden"):countContainer.text(count)}};return{show:function(namespace,header,body,footer,tab){(body=$(body)).attr("data-contacts-init")||(!function(body){var contactsSection=getContactsSectionContainer(body),requestsSection=getRequestsSectionContainer(body),showContactsAction=getShowContactsAction(body),showRequestsAction=getShowRequestsAction(body);showContactsAction[0].addEventListener("show.bs.tab",(function(){ContactsSection.show(contactsSection)})),showRequestsAction[0].addEventListener("show.bs.tab",(function(){RequestsSection.show(requestsSection)})),PubSub.subscribe(MessageDrawerEvents.CONTACT_REQUEST_ACCEPTED,decrementContactRequestCount(body)),PubSub.subscribe(MessageDrawerEvents.CONTACT_REQUEST_DECLINED,decrementContactRequestCount(body))}(body),body.attr("data-contacts-init",!0));var contactsSection=getContactsSectionContainer(body),requestsSection=getRequestsSectionContainer(body);if(tab){var showContactsAction=getShowContactsAction(body),showRequestsAction=getShowRequestsAction(body);"requests"==tab?(showContactsAction.removeClass("active"),contactsSection.removeClass("show active"),showRequestsAction.addClass("active"),requestsSection.addClass("show active")):(showRequestsAction.removeClass("active"),requestsSection.removeClass("show active"),showContactsAction.addClass("active"),contactsSection.addClass("show active"))}return contactsSection.hasClass("active")?ContactsSection.show(contactsSection):RequestsSection.show(requestsSection),$.Deferred().resolve().promise()},description:function(){return Str.get_string("messagedrawerviewcontacts","core_message")}}}));

//# sourceMappingURL=message_drawer_view_contacts.min.js.map