define("core/local/aria/aria-hidden",["exports","core/normalise","./selectors"],(function(_exports,_normalise,_selectors){var obj;
/**
   * ARIA helpers related to the aria-hidden attribute.
   *
   * @module     core/local/aria/aria-hidden.
   * @copyright  2020 Andrew Nicols <andrew@nicols.co.uk>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.unhideSiblings=_exports.unhide=_exports.hideSiblings=_exports.hide=void 0,_selectors=(obj=_selectors)&&obj.__esModule?obj:{default:obj};const childObserverMap=new Map,siblingObserverMap=new Map,supportsMutationObservers=()=>MutationObserver&&"function"==typeof MutationObserver,disableElementFocusability=target=>{target instanceof HTMLElement&&(target.matches(_selectors.default.elements.focusable)&&disableAndStoreTabIndex(target),target.querySelectorAll(_selectors.default.elements.focusable).forEach(disableAndStoreTabIndex))},disableAndStoreTabIndex=element=>{void 0===element.dataset.ariaHiddenTabIndex&&(element.getAttribute("tabindex")?element.dataset.ariaHiddenTabIndex=element.getAttribute("tabindex"):element.dataset.ariaHiddenTabIndex="",element.setAttribute("tabindex",-1))},restoreTabIndex=element=>{if(element.closest(_selectors.default.aria.hidden))return;const oldTabIndex=element.dataset.ariaHiddenTabIndex;""===oldTabIndex?element.removeAttribute("tabindex"):element.setAttribute("tabindex",oldTabIndex),delete element.dataset.ariaHiddenTabIndex},hide=target=>(0,_normalise.getList)(target).forEach(_hide);_exports.hide=hide;const _hide=target=>{if(target instanceof HTMLElement&&!target.closest(_selectors.default.aria.hidden)&&(target.setAttribute("aria-hidden",!0),disableElementFocusability(target),supportsMutationObservers())){const mutationObserver=new MutationObserver((mutationList=>{mutationList.forEach((mutation=>{if("childList"===mutation.type)mutation.addedNodes.forEach(disableElementFocusability);else if("attributes"===mutation.type){const element=mutation.target,proposedTabIndex=element.getAttribute("tabindex");"-1"!==proposedTabIndex&&(element.dataset.ariaHiddenTabIndex=proposedTabIndex,element.setAttribute("tabindex",-1))}}))}));mutationObserver.observe(target,{subtree:!0,childList:!0,attributes:!0,attributeFilter:["tabindex"]}),childObserverMap.set(target,mutationObserver)}},unhide=target=>(0,_normalise.getList)(target).forEach(_unhide);_exports.unhide=unhide;const _unhide=target=>{target instanceof HTMLElement&&(target.removeAttribute("aria-hidden"),(target=>{target instanceof HTMLElement&&(target.matches(_selectors.default.elements.focusableToUnhide)&&restoreTabIndex(target),target.querySelectorAll(_selectors.default.elements.focusableToUnhide).forEach(restoreTabIndex))})(target),childObserverMap.has(target)&&(childObserverMap.get(target).disconnect(),childObserverMap.delete(target)))};_exports.hideSiblings=target=>(0,_normalise.getList)(target).forEach(_hideSiblings);const _hideSiblings=target=>{if(target instanceof HTMLElement&&target.parentElement&&(target.parentElement.childNodes.forEach((node=>{node!==target&&hide(node)})),supportsMutationObservers())){const newNodeObserver=new MutationObserver((mutationList=>{mutationList.forEach((mutation=>{mutation.addedNodes.forEach((node=>{target.contains(node)||hide(node)}))}))}));newNodeObserver.observe(target.parentElement,{childList:!0,subtree:!0}),siblingObserverMap.set(target.parentElement,newNodeObserver)}};_exports.unhideSiblings=target=>(0,_normalise.getList)(target).forEach(_unhideSiblings);const _unhideSiblings=target=>{target instanceof HTMLElement&&target.parentElement&&(target.parentElement.childNodes.forEach((node=>{node!==target&&unhide(node)})),siblingObserverMap.has(target.parentElement)&&(siblingObserverMap.get(target.parentElement).disconnect(),siblingObserverMap.delete(target.parentElement)))}}));

//# sourceMappingURL=aria-hidden.min.js.map